    device zxspectrum48



	org 40000

begin

	ei
	ld sp,40000
	
	ld hl,#5800
	ld de,#5801
	ld bc,768-1
	xor a
	halt
	out (#fe),a
	ld (hl),a
	ldir
	
	ld hl,screen
	ld de,#4000
	ld bc,6144
	ldir
	
	ld hl,screen+6144
	ld de,#5800
	ld bc,768
	halt
	ldir

	call snow_setup
	
	call music_init


	
main_loop:

	halt
	
	call snow_clear
	
	call scroll_16px_render
	call scroll_8px_render
	
	call snow_render_and_update
	
	call scroll_attr_render
	
	call cycle_attrs
	
	call music_play
	
	call scroll_attr_prepare
	call scroll_attr_advance	
	
	call scroll_small_prepare
	push ix
	call scroll_8px_update
	pop ix
	call scroll_16px_update

	call scroll_small_advance
	
	jp main_loop
	
	
	
;перемигивание цветов согласно карте

cycle_attrs:

	ld a,(cycle_attr)
	inc a
	and 3
	ld (cycle_attr),a

	jp z,.top
	cp 2
	jp z,.bottom
	ret
	
.top

	ld hl,#5800
	ld de,flash
	ld b,9
	jp .cycle
	
.bottom

	ld hl,#5800+9*32
	ld de,flash+9*32
	ld b,16-9
	jp .cycle
	
.cycle:

	push bc

	ld bc,#4007
	
	dup 32
	
	ld a,(de)				;читаем байт атрибутной маски
	or a					;проверяем на 0
	jr nz,$+7				;пропускаем последующий код, если не 0

	ld a,(hl)				;читаем байт атрибута из экрана
	dec a					;декрементируем
	and c					;регистр C=7, оставляем три младших бита (INK)
	or b					;регистр B=64, накладываем бит яркости
	ld (hl),a				;возвращаем байт атрибута в экран

	inc l
	inc e
	
	edup
	
	dec l
	inc hl
	dec e
	inc de

	pop bc
	dec b
	jp nz,.cycle
	
	ret
	
	

;готовим новый столбец пикселей для аттрибутного скролла

SCROLL_BIG_ATTR=(7<<3)+5+64
SCROLL_BIG_SHADOW=(1<<3)+5+64
SCROLL_BIG_BACK=5+64
	
scroll_attr_prepare:
	
	ld a,(back_flash)
	inc a
	ld (back_flash),a
	ld c,a
	
	ld hl,scroll_big_column+6
	ld de,scroll_big_column+5
	ld b,6
.shadow:
	ld a,(de)
	cp SCROLL_BIG_ATTR
	jr z,.setshadow
	ld a,c
	and 1
	add a,SCROLL_BIG_BACK
	jr .putattr
.setshadow:
	ld a,SCROLL_BIG_SHADOW
.putattr:
	ld (hl),a
	dec hl
	dec de
	inc c
	djnz .shadow
	ld (hl),SCROLL_BIG_BACK
	
	ld hl,(scroll_big_ptr)
	ld a,(hl)
	and 127
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	ld bc,FONT_ROM-32*8+1				;стандартный шрифт в ПЗУ, на строку ниже первого пикселя и с учётом, что в шрифте нет первых 32 символов
	add hl,bc
	
	ld a,(scroll_big_mask)
	ld c,a
	ld b,7
	ld de,scroll_big_column

.render:

	ld a,(hl)
	and c
	jr z,.next
	ld a,SCROLL_BIG_ATTR
	ld (de),a

.next:

	inc hl
	inc de
	djnz .render
	
	ret
	
	
	
	;продвигаем указатель большого скролла и зацикливаем где надо
	
scroll_attr_advance:

	ld hl,scroll_big_mask
	ld a,(hl)
	srl a
	jr nz,.noinc
	
	ld de,(scroll_big_ptr)
	ld a,(de)
	inc de
	rla
	jr nc,.noloop
	ld de,scroll_big_text
.noloop:
	ld (scroll_big_ptr),de
	ld a,128
.noinc:
	ld (hl),a
	
	ret
	
	
	
	;подготовка текущего символа для пиксельных скроллеров

scroll_small_prepare:
	
	ld hl,(scroll_small_ptr)
	ld a,(hl)
	and 127
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	ld bc,FONT_DIZZY-32*8+7				;стандартный шрифт в ПЗУ, на последнюю строку символа и с учётом, что в шрифте нет первых 32 символов
	add hl,bc
	push hl
	pop ix
	
	ret
	
	
	
;продвигаем указатель малых скроллеров и зацикливаем где надо

scroll_small_advance:

	ld hl,scroll_small_mask
	ld a,(hl)
	srl a
	jr nz,.noinc
	
	ld de,(scroll_small_ptr)
	ld a,(de)
	inc de
	rla
	jr nc,.noloop
	ld de,scroll_small_text
.noloop:
	ld (scroll_small_ptr),de
	ld a,128
.noinc:
	ld (hl),a
	
	ret
	
	
	
	;прокрутка маленького пиксельного скроллера на 1 пиксель

scroll_8px_update:
	
	ld hl,scroll_small_buf8+7*32
	ld b,7

.loop1:

	ld a,(scroll_small_mask)	
	and (ix)
	jr z,$+3
	scf
	
	dec hl			;идём по экрану в обратном порядке, может измениться H
	rl (hl)			;сдвигаем пиксель влево, вдвигая справа заранее подготовленный бит символа
	dup 31			;повторяем 31 раз
	dec l			;переходим на знакоместо влево, H гарантированно не меняется
	rl (hl)			;сдвигаем пиксель влево, вдвигая справа предыдущий выдвинутый влево пиксель
	edup			;заканчиваем повторения
	
	dec ix
	
	djnz .loop1

	ret
	
	
	
	;прокрутка среднего пиксельного скроллера на 2 пикселя
	
scroll_16px_update:

	ld hl,scroll_small_buf16+7*32
	ld b,7

.loop2:

	ld a,(scroll_small_mask)
	and (ix)
	jr z,$+3
	scf
	
	push hl
	dec hl
	rl (hl)
	dup 31
	dec l
	rl (hl)
	edup
	pop hl
	
	scf
	ccf
	
	dec hl
	rl (hl)
	dup 31
	dec l
	rl (hl)
	edup
	
	dec ix
	
	dec b
	jp nz,.loop2
	
	ret
	
	
	
	;большой атрибутный скролл
	;одновременно и скроллим атрибуты, и выводим заранее заготовленный столбец

scroll_attr_render:

	ld ix,scroll_big_column
	ld hl,#5800+32*17
	ld b,7
	
.loop:

	push bc
	push hl
	ld e,l
	ld d,h
	inc hl
	dup 31				;повторяем 31 раз
	ldi					;копируем один байт из HL в DE, инкрементируем HL и DE
	edup				;заканчиваем повторение
	
	dec hl
	ld a,(ix)
	ld (hl),a
	inc ix
	
	pop hl
	ld bc,32
	add hl,bc
	pop bc
	djnz .loop
	
	ret
	
	
	
;вывод буфера маленького пиксельного скроллера на экран

scroll_8px_render:

	ld hl,scroll_small_buf8
	ld de,#4000+4096+32*5
	ld b,7
	
.loop1:

	push de
	push bc
	dup 32
	ldi
	edup
	pop bc
	pop de
	ex de,hl
	call down_hl
	ex de,hl
	djnz .loop1
	
	ret
	
	
	
;вывод буфера большого пиксельного скроллера на экран

scroll_16px_render:

	ld hl,scroll_small_buf16
	ld de,#4000+4096+32*3
	ld b,7
	
.loop1:

	push de
	push bc
	dup 32
	ldi
	edup
	pop bc
	pop de
	ex de,hl
	call down_hl
	call down_hl
	ex de,hl
	djnz .loop1
	
	ret
	

	
snow_setup:

	ld ix,snow_array
	ld b,SNOW_MAX
	ld de,SNOW_SIZE
	
.loop:

	call random
	ld (ix+SNOW_ANIM),a
	call random
	and 31
	ld (ix+SNOW_X),a
	call random
	and 127
	ld (ix+SNOW_Y),a
	add ix,de
	djnz .loop
	
	ret
	
	
	
snow_clear:

	ld ix,snow_array
	ld iy,snow_anim
	ld b,SNOW_MAX
	ld d,0				;всегда 0 в цикле

.loop:

	ld a,(ix+SNOW_Y)
	cp 192-7*8
	jr c,.skipclr
	
	ld h,screen_table_l/256
	ld l,a
	
	ld a,(hl)
	inc h
	ld h,(hl)
	or (ix+SNOW_X)
	ld l,a
	
	ld (hl),d			;стираем снежинку
	
.skipclr:

	ld e,SNOW_SIZE
	add ix,de
	
	djnz .loop
	
	ret
	
	
	
snow_render_and_update:

	ld ix,snow_array
	ld iy,snow_anim
	ld b,SNOW_MAX
	ld d,0				;всегда 0 в цикле

.loop:

	ld a,(ix+SNOW_Y)
	inc a
	cp 192
	jr c,.draw
	
	call random			;генерируем новую снежинку
	and 31
	ld (ix+SNOW_X),a
	
	call random
	and 63
	add a,192-7*8-64
	
.draw:

	ld (ix+SNOW_Y),a
	cp 192-7*8
	jr c,.skipset
	
	ld h,screen_table_l/256
	ld l,a
	
	ld a,(hl)
	inc h
	ld h,(hl)
	or (ix+SNOW_X)
	ld l,a

	ld a,(ix+SNOW_ANIM)
	
	exx
	ld hl,snow_anim
	and 15
	add a,l
	ld l,a
	ld a,(hl)
	exx
	
	or (hl)
	ld (hl),a
	
.skipset:
	
	inc (ix+SNOW_ANIM)
	
	ld e,SNOW_SIZE
	add ix,de
	
	djnz .loop
	
	ret
	
	
	
random:

	push hl
	ld hl,(random_ptr)
	inc hl
	ld a,h
	and #3f
	ld h,a
	ld (random_ptr),hl
	ld a,r
	add a,(hl)
	add a,l
	pop hl
	
	ret



down_hl:

    inc h
    ld a,h
    and #07
    ret nz
    ld a,l
    sub #e0
    ld l,a
    sbc a,a
    and #f8
    add a,h
    ld h,a
	ret
	
	
	
random_ptr:	dw 0

SNOW_MAX=64
SNOW_X=0
SNOW_Y=1
SNOW_ANIM=2
SNOW_SIZE=3

snow_array:		ds SNOW_MAX*SNOW_SIZE,0

	align 16
	
snow_anim:

	db %00001000
	db %00010000
	db %00100000
	db %01000000
	db %10000000
	db %10000000
	db %01000000
	db %00100000
	db %00010000
	db %00001000
	db %00000100
	db %00000010
	db %00000001
	db %00000001
	db %00000010
	db %00000100


	align 256
screen_table_l:
SCR_Y=0
	dup 192
SCR_ADR=#4000+((SCR_Y/64)*2048)+(((SCR_Y/8)&7)*32)+((SCR_Y&7)*256)
	db SCR_ADR&255
SCR_Y=SCR_Y+1
	edup
	align 256
screen_table_h:
SCR_Y=0
	dup 192
SCR_ADR=#4000+((SCR_Y/64)*2048)+(((SCR_Y/8)&7)*32)+((SCR_Y&7)*256)
	db SCR_ADR/256
SCR_Y=SCR_Y+1
	edup


cycle_attr:			db 0
back_flash:			db 0

scroll_big_ptr:		dw scroll_big_text
scroll_big_mask:	db 128
scroll_big_column:	ds 7,0

scroll_small_ptr:	dw scroll_small_text
scroll_small_mask:	db 128

	align 256
scroll_small_buf8:	ds 32*7,0
	align 256
scroll_small_buf16:	ds 32*7,0

scroll_small_text:

	db "                                "
	db "*** SHIRU8BIT WISHES YOU MERRY CHRISTMAS AND A HAPPY NEW YEAR! ***"
	db "                                "
	db "GREETZ TO ALL MY FRIENDS AND ALL COMPUTER ENTHUSIASTS ALL AROUND THE WORLD! "
	db "                                "
	db "SPECIAL HELLO TO ROMAN SOKOLOV, CHRV, JEDIHUT, SHURAN, JUSTEVGEN, SAVELIJ, TRUE GRUE, KOE, SANYA TASHEE, "
	db "DIMKAM, PINWIZZ, MR.287, DAVID MURRAY, SERGIO ELISONDO!"
	db "                                "
	db "GRAPHICS BORROWED FROM SABOTEUR, EXOLON, REX, JET SET WILLY, DIZZY, RICK DANGEROUS, DAN DARE."
	db "                                "
	db "MUSIC BORROWED FROM LYRA II PART 3, ORIGINALLY BY DUSTY SPRINGFIELD."
	db "                                "
	db "REMEMBERING COOL PEOPLE WHO BROUGHT US THESE GAMES, EARLY DEMOS, AND LOTS OF OTHER STUFF IN THE PAST: "
	db "VASILYEV ANTON, KULIKOV DMITRIY, ANDY CHERNIKOV, SERGEY SKOROBOGATOV, PAVEL NIKITIN, NICOLAS RODIONOV, "
	db "MAX IWAMOTO, KSA, *L*F*A*, MAGIC SOFT, SOFTSTAR, BILL GILBERT, AND MANY OTHERS."
	db "                                "
	db "KEEP GOOD OLD TRADITIONS ALIVE!"
	db "                                "
	db 32+128
	
scroll_big_text:

	db "                                "
	db "                                "
	db "2026 COMING SOON!"
	db "                                "
	db "                                "
	db "HAPPY NEW YEAR!"
	db "                                "
	db "                                "
	db "MERRY X-MAS!"
	db "                                "
	db "                                "
	db "ALL BEST WISHES!"
	db "                                "
	db "                                "
	db 32+128
	
FONT_ROM=#3d00
FONT_DIZZY:
	incbin "dizzy.bin"
			
	define PUREPLAYER
	include "stcplay.asm"
songdata:
	incbin "lyra3.bin"
	
	align 256

screen:
	incbin "screen.bin"
	
flash:
	incbin "flash.bin",6144,32*16

end
	display /d,end-begin

	savesna "intro.sna",begin
	savebin "ny2026c.bin",begin,end-begin